from pydantic import create_model

DynamicUser = create_model(
    "DynamicUser",
    username=(str, Field(..., min_length=3)),
    score=(int, Field(default=0, ge=0)),
)

user = DynamicUser(username="Alice", score=10)
print(user.dict())
