# 匯入本地的 error_printer 模組
import error_printer

# 配置 pretty_errors 和 icecream
error_printer.configure_pretty_errors()
error_printer.configure_icecream()

# 測試代碼
from icecream import ic

def divide(a, b):
    return a / b

try:
    result = divide(10, 0)
except ZeroDivisionError as e:
    ic(e)  # 使用 icecream 輸出錯誤資訊
    raise  # 重新拋出異常以觸發 pretty_errors 的輸出
