import pretty_errors
from icecream import ic


def configure_pretty_errors() -> None:
    """
    配置 pretty_errors 庫，用於更好的錯誤輸出。

    不需要任何參數。
    """
    pretty_errors.configure(
        line_number_first=True,  # 顯示行號在前面
        lines_before=5,  # 顯示錯誤行之前的行數
        lines_after=2,  # 顯示錯誤行之後的行數
        line_color=pretty_errors.RED
        + "> "
        + pretty_errors.default_config.line_color,  # 自訂錯誤行的顏色
        display_locals=True,  # 顯示局部變數
    )


def configure_icecream() -> None:
    """
    配置 icecream 庫，用於更好的 print 輸出。

    不需要任何參數。
    """
    ic.configureOutput(includeContext=True)  # 設定 icecream 函式庫的輸出格式
    ic.enable()  # 開啟 icecream 的輸出
    # ic()  # 印出除錯資訊
