from datetime import date

import pretty_errors
import streamlit as st
from pydantic import BaseModel, Field


class User(BaseModel):
    id: int
    name: str
    dob: date = Field(title="Date of Birth")

    def __str__(self):
        return f"User(id={self.id}, name={self.name}, dob={self.dob})"


# 設定 pretty_errors 的顯示配置
pretty_errors.configure(
    line_number_first=True,  # 顯示行號在前面
    lines_before=5,  # 顯示錯誤行之前的行數
    lines_after=2,  # 顯示錯誤行之後的行數
    line_color=pretty_errors.RED
    + "> "
    + pretty_errors.default_config.line_color,  # 自訂錯誤行的顏色
    display_locals=True,  # 顯示局部變數
)


# 定義一些使用者
users = [
    User(id=1, name="John", dob=date(1990, 1, 1)),
    User(id=2, name="Jack", dob=date(1991, 1, 1)),
    User(id=3, name="Jill", dob=date(1992, 1, 1)),
    User(id=4, name="Jane", dob=date(1993, 1, 1)),
]

# 在 Streamlit 應用程式中展示使用者資訊
st.title("User Information")
for user in users:
    st.write(f"ID: {user.id}, Name: {user.name}, Date of Birth: {user.dob}")
