import asyncio
import websockets
import streamlit as st
import threading
import socket

# Function to check if a port is free
def is_port_free(port):
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        return s.connect_ex(('localhost', port)) != 0

# WebSocket Server Logic
async def echo(websocket, path):
    async for message in websocket:
        print(f"收到訊息: {message}")
        await websocket.send(f"伺服器回應: {message}")

# Function to start the WebSocket server
def start_server():
    new_loop = asyncio.new_event_loop()
    asyncio.set_event_loop(new_loop)
    server = websockets.serve(echo, "localhost", 8765)
    new_loop.run_until_complete(server)
    new_loop.run_forever()

# Initialize session state for server
if 'server_started' not in st.session_state:
    st.session_state.server_started = False

# Start the server only once
if not st.session_state.server_started:
    if is_port_free(8765):
        server_thread = threading.Thread(target=start_server, daemon=True)
        server_thread.start()
        st.session_state.server_started = True
        st.success("WebSocket 伺服器已啟動。")
    else:
        st.error("Port 8765 已被佔用。請確保沒有其他應用程式使用該埠，或更改埠號。")

st.title("WebSocket Example")

# WebSocket Client Logic
async def websocket_client():
    try:
        async with websockets.connect("ws://localhost:8765") as websocket:
            await websocket.send("你好，WebSocket!")
            response = await websocket.recv()
            st.write(f"伺服器回應: {response}")
    except Exception as e:
        st.error(f"WebSocket 連線失敗: {e}")

# Run WebSocket Client on Button Click
if st.button("發送訊息"):
    asyncio.run(websocket_client())

