#!/bin/bash

# 啟用 en_US.UTF-8 語言環境
echo "啟用 en_US.UTF-8 語言環境..."
sudo sed -i '/^# en_US.UTF-8 UTF-8/s/^# //' /etc/locale.gen
sudo locale-gen

# 設定語言環境變數
echo "設定語言環境變數..."
export LANG=en_US.UTF-8
export LANGUAGE=en_US:en

# 將設定寫入 .bashrc，以便持久化
echo "將語言設定寫入 ~/.bashrc..."
echo 'export LANG=en_US.UTF-8' >> ~/.bashrc
echo 'export LANGUAGE=en_US:en' >> ~/.bashrc

# 提示完成並建議重新啟動 shell
echo "語言環境設定完成。請重新啟動終端或執行 'source ~/.bashrc' 以應用更改。"
