import streamlit as st  # 匯入 streamlit 模組
import streamlit_authenticator as stauth  # 匯入 streamlit_authenticator 模組

names = ["John", "Mary"]  # 定義名字清單
usernames = ["john", "mary"]  # 定義使用者名清單
passwords = ["1234", "5678"]  # 定義密碼清單

hashed_passwords = stauth.Hasher(passwords).generate()  # 使用 Hasher 類別對密碼進行雜湊處理

authenticator = stauth.Authenticate(  # 建立一個 stauth.Authenticate 的實例 authenticator
    names,  # 使用 names 清單
    usernames,  # 使用 usernames 清單
    hashed_passwords,  # 使用雜湊後的密碼清單
    'some_cookie_name',  # 設定 cookie 名稱為 'some_cookie_name'
    'some_signature_key',  # 設定簽名金鑰為 'some_signature_key'
    cookie_expiry_days=30  # 設定 cookie 有效天數為 30 天
)

name, authentication_status = authenticator.login('Login', 'main')  # 進行登入驗證，並顯示 "Login" 按鈕，連接到 "main"

if authentication_status == False:  # 如果驗證狀態為假
    st.error('Username/password is incorrect')  # 顯示錯誤訊息，提示使用者帳號或密碼不正確
elif authentication_status == None:  # 如果驗證狀態為空
    st.warning('Please enter your username and password')  # 顯示警告訊息，提示使用者輸入帳號和密碼
else:
    st.write('Welcome *%s*' % (name))  # 顯示歡迎訊息，使用 name 變數的值

    with st.sidebar:  # 在側邊欄中
        authenticator.logout('Logout', 'main')  # 顯示 "Logout" 按鈕，連接到 "main"