import loguru

loguru.logger.add("logfile_{time}.log")

logger = loguru.logger

logger.debug("Debug message")
logger.info("Info message")
logger.warning("Warning message")
logger.error("Error message")
logger.critical("Critical message")

try:
    raise ValueError("This is a test error")
except ValueError as e:
    logger.exception(e)  # 處理例外，並顯示訊息


logger.success("Success message")  # 顯示Success訊息
logger.log("Custom level", "Custom message")  # 顯示自訂等級的訊息

logger.remove()  # 移除logger

logger.opt(depth=1).log("Traceback message")  # 顯示Traceback訊息，並限制深度為1

# 增加一個logfile，包含時間戳記和追蹤訊息
logger.add("logfile_{time}.log", backtrace=True)

logger.debug("Debug message with backtrace")
logger.info("Info message with backtrace")
logger.warning("Warning message with backtrace")
logger.error("Error message with backtrace")
logger.critical("Critical message with backtrace")

try:
    raise ValueError("This is a test error with backtrace")
except ValueError as e:
    logger.exception(e)

logger.success("Success message with backtrace")
logger.log("Custom level with backtrace", "Custom message with backtrace")

logger.remove()
