import streamlit as st
import pandas as pd
import json
import streamlit.components.v1 as components

# 假設有一個 DataFrame
df = pd.DataFrame({
    "訂單單別": ["A", "B", "C"],
    "訂單單號": [101, 102, 103],
    "客戶簡稱": ["客戶1", "客戶2", "客戶3"],
    "備註": ["備註A", "備註B", "備註C"],
})

# 將 DataFrame 轉成 JSON 格式
data_json = df.to_json(orient="records")

# 撰寫 HTML 與 JavaScript，利用 Tabulator 顯示資料
html_code = f"""
<!DOCTYPE html>
<html>
  <head>
    <link href="https://unpkg.com/tabulator-tables@5.4.4/dist/css/tabulator.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://unpkg.com/tabulator-tables@5.4.4/dist/js/tabulator.min.js"></script>
  </head>
  <body>
    <div id="tabulator-table" style="width: 100%;"></div>
    <script type="text/javascript">
      // 從 Streamlit 傳入的 JSON 資料
      var tableData = {data_json};

      // 定義欄位設定
      var columns = [
        {{title:"訂單單別", field:"訂單單別", headerFilter:"input"}},
        {{title:"訂單單號", field:"訂單單號", headerFilter:"input"}},
        {{title:"客戶簡稱", field:"客戶簡稱", headerFilter:"input"}},
        {{title:"備註", field:"備註", headerFilter:"input", editor:"input"}},
      ];

      // 初始化 Tabulator
      var table = new Tabulator("#tabulator-table", {{
        data:tableData,
        columns:columns,
        layout:"fitColumns",
        pagination:"local",
        paginationSize:5,
      }});

      // 若需要回傳編輯後的資料，可以透過 window.parent.postMessage 傳送回 Streamlit
      // 這部分需要進一步開發與整合
    </script>
  </body>
</html>
"""

# 使用 Streamlit 的 components.v1.html 嵌入此 HTML 頁面
components.html(html_code, height=600, scrolling=True)
st.write("這是一個使用 Tabulator 顯示資料的基本範例。")

