from multiprocessing import Process, Pipe

def worker(conn):
    conn.send("Hello from child process")  # 傳送訊息
    msg = conn.recv()  # 接收訊息
    print(f"Child received: {msg}")
    conn.close()

if __name__ == "__main__":
    parent_conn, child_conn = Pipe()  # 建立 Pipe 雙向通道

    p = Process(target=worker, args=(child_conn,))
    p.start()

    print(f"Parent received: {parent_conn.recv()}")  # 從子進程接收訊息
    parent_conn.send("Hello from parent process")  # 發送訊息到子進程

    p.join()  # 等待子進程結束
