import tempfile

with tempfile.NamedTemporaryFile(delete=False) as temp_file:
    print(f"建立的臨時檔案: {temp_file.name}")
    temp_file.write(b"這是一個具名的臨時檔案。\n")

# `delete=False` 允許我們在 `with` 區塊外存取該檔案
print("檔案仍然存在，可用於後續操作。")
